/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rescrcon;

import com.ibm.hwmca.base.rescrcon.Actbrst;
import com.ibm.hwmca.base.rescrcon.RestoreCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.rescrcon.RestoreErrorIds;
import com.ibm.hwmca.base.rescrcon.RestoreException;
import com.ibm.hwmca.base.rescrcon.RestoreParameterKeys;
import com.ibm.hwmca.base.rescrcon.RestoreParameters;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;

class RestoreImpl
implements RestoreErrorIds,
RestoreParameterKeys {
    private static final String TRACE_MASKT = "XRCCIMPT";
    private static final String TRACE_MASKF = "XRCCIMPF";
    private static final String TRACE_MASKD = "XRCCIMPD";
    private RestoreParameters restoreParameters = null;
    private MediaDevice restoreDevice = null;
    private LocalizableText mediaName = null;
    private int returnState;
    private Actbrst hdAct = null;
    private Actbrst tarAct = null;
    private boolean wrongEC = false;
    private boolean wrongVer = false;

    RestoreImpl() {
        Trace.trace(TRACE_MASKT, "-> RestoreImpl.RestoreImpl()");
        this.restoreParameters = RestoreParameters.getRestoreParameters();
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.RestoreImpl()");
    }

    /*
     * Exception decompiling
     */
    boolean isRestoreNeeded() throws RestoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void restorePreparation() throws RestoreException {
        Trace.trace(TRACE_MASKT, "-> RestoreImpl.restorePreparation()");
        try {
            this.loadRestoreMedia();
            this.checkECVer();
            if (this.wrongEC || this.wrongVer) {
                LocalizableText errorMsgSuffix = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ecver.error");
                String errorMsgString = "";
                String eoln = "\n";
                if (this.wrongEC) {
                    LocalizableText errorMsgEC = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ec.error");
                    errorMsgString = errorMsgEC.toString() + " " + this.tarAct.getEC() + " " + errorMsgSuffix.toString() + " " + this.hdAct.getEC();
                    this.returnState = 9;
                }
                if (this.wrongVer) {
                    LocalizableText errorMsgVer = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ver.error");
                    if (this.wrongEC) {
                        errorMsgString = errorMsgString + eoln;
                    }
                    errorMsgString = errorMsgString + errorMsgVer.toString() + " " + this.tarAct.getVER() + " " + errorMsgSuffix.toString() + " " + this.hdAct.getVER();
                    this.returnState = 10;
                }
                if (this.wrongEC && this.wrongVer) {
                    this.returnState = 11;
                }
                throw new RestoreException(errorMsgString);
            }
            Trace.trace(TRACE_MASKF, "EC and Versions match");
            this.returnState = 0;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception during restore preparation: " + exc);
            this.releaseLock(this.restoreDevice);
            throw new RestoreException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.restorePreparation()");
    }

    private void loadRestoreMedia() throws RestoreException {
        try {
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier restoreMediaId = ms.getPreferredDevice(6);
            this.mediaName = ms.getMediaDisplayableName(6);
            this.restoreDevice = ms.requestLock(new LocalizableText("Restore Critical Console Data"), restoreMediaId);
            if (this.restoreDevice.getLabel() == null) {
                throw new RestoreException("wrong label: " + this.restoreDevice.getLabel());
            }
            if (!this.restoreDevice.getLabel().equals("ACTBKP")) {
                this.returnState = 5;
                throw new RestoreException("wrong label: " + this.restoreDevice.getLabel());
            }
            this.restoreDevice.mountReadOnly();
            this.returnState = 0;
        }
        catch (IllegalArgumentException e) {
        }
        catch (MediaDeviceLockException e) {
            this.returnState = 1;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (NoMediaPresentException e) {
            this.returnState = 3;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (InvalidFileSystemException e) {
            this.returnState = 7;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (MediaDeviceException e) {
            this.returnState = 4;
            RestoreException rexc = new RestoreException(e);
            new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
            throw rexc;
        }
        catch (RestoreException rexc) {
            this.returnState = 5;
            throw rexc;
        }
    }

    private void checkECVer() throws RestoreException {
        Trace.trace(TRACE_MASKF, "-> RestoreImpl.checkECVer()");
        String actbrst = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.actbrst");
        String[] cmd = new String[4];
        cmd[0] = this.restoreParameters.getParm("restore.getactbrst.script");
        cmd[2] = actbrst;
        cmd[3] = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.log");
        try {
            cmd[1] = this.restoreDevice.getMountPoint().getAbsolutePath() + "/" + this.restoreParameters.getParm("restore.archive");
            int rc = RootProcess.executeProgram(cmd);
            Trace.trace(TRACE_MASKF, cmd[0] + " completed with rc=" + rc);
            this.hdAct = new Actbrst(actbrst);
            this.tarAct = new Actbrst("/tmp/" + actbrst);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "checkECVer: " + exc.getMessage());
            throw new RestoreException(exc);
        }
        this.wrongEC = !this.hdAct.getEC().equals(this.tarAct.getEC());
        this.wrongVer = !this.hdAct.getVER().equals(this.tarAct.getVER());
        Trace.trace(TRACE_MASKF, "<- RestoreImpl.checkECVer()");
    }

    synchronized void restore(ProgressReportListenerImpl restoreListener) throws RestoreException {
        Trace.trace(TRACE_MASKT, "-> RestoreImpl.restore()");
        String flagFileDeleted = " ";
        String[] cmd = new String[3];
        cmd[0] = this.restoreParameters.getParm("restore.script");
        cmd[2] = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.log");
        try {
            try {
                cmd[1] = this.restoreDevice.getMountPoint().getAbsolutePath() + "/" + this.restoreParameters.getParm("restore.archive");
                int rc = RootProcess.executeProgram(cmd);
                Trace.trace(TRACE_MASKF, cmd[0] + " completed with rc=" + rc);
                this.restoreDevice.unmount();
                String reportStr = null;
                if (rc == 0) {
                    this.returnState = 0;
                    if (!this.deleteFlagFile()) {
                        flagFileDeleted = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", RestoreCriticalConsoleDataResourceBundle.RestoreErrors(13)).toString();
                    }
                } else {
                    if (rc == 1) {
                        throw new IOException("utar failed");
                    }
                    throw new IOException("unknown error");
                }
                reportStr = "Restore Successful" + flagFileDeleted;
                CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.SUCCESS, reportStr);
                restoreListener.finished(report);
                Object var9_10 = null;
                this.releaseLock(this.restoreDevice);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "restore(): " + exc.getMessage());
                BaseMessageText bmt = new BaseMessageText("RES00007");
                CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.FAIL, bmt.toString());
                restoreListener.finished(report);
                this.returnState = 6;
                RestoreException rexc = new RestoreException(exc);
                new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                throw rexc;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseLock(this.restoreDevice);
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.restore()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteFlagFile() {
        boolean deletedFile;
        block14: {
            Trace.trace(TRACE_MASKT, "-> RestoreImpl.deleteFlagFile()");
            MediaDevice upgradeDevice = null;
            deletedFile = true;
            try {
                MediaServices ms = MediaServices.getMediaServices();
                MediaDeviceIdentifier upgradeMediaId = ms.getPreferredDevice(4);
                upgradeDevice = ms.requestLock(new LocalizableText("Restore Critical Console Data"), upgradeMediaId);
                Trace.trace(TRACE_MASKF, "Mountpoint is: " + upgradeDevice.getMountPoint().toString());
                Trace.trace(TRACE_MASKF, "Upgrade partition is: " + this.restoreParameters.getParm("upgrade.partition"));
                if (!upgradeDevice.getMountPoint().toString().equals(this.restoreParameters.getParm("upgrade.partition"))) {
                    throw new RestoreException("wrong partition");
                }
                upgradeDevice.mountReadWrite();
                File flagFileL = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toLowerCase());
                Trace.trace(TRACE_MASKF, "flag file lower case name is: " + flagFileL.getAbsolutePath());
                File flagFileU = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toUpperCase());
                Trace.trace(TRACE_MASKF, "flag file upper case name is: " + flagFileU.getAbsolutePath());
                if (flagFileL.exists() && !flagFileL.delete()) {
                    deletedFile = false;
                }
                if (flagFileU.exists() && !flagFileU.delete()) {
                    deletedFile = false;
                }
                Trace.trace(TRACE_MASKF, "doing final release on upgrade partition");
            }
            catch (Exception e) {
                deletedFile = false;
                break block14;
            }
            try {
                this.releaseLock(upgradeDevice);
            }
            catch (Exception exc) {
                this.returnState = 1;
                RestoreException rexc = new RestoreException(exc);
                new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
            }
            break block14;
            finally {
                Trace.trace(TRACE_MASKF, "doing final release on upgrade partition");
                try {
                    this.releaseLock(upgradeDevice);
                }
                catch (Exception exc) {
                    this.returnState = 1;
                    RestoreException rexc = new RestoreException(exc);
                    new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.deletedFlagFile()");
        return deletedFile;
    }

    LocalizableText getMediaName() {
        return this.mediaName;
    }

    int getState() {
        return this.returnState;
    }

    private void releaseLock(MediaDevice device) {
        try {
            device.unlock();
        }
        catch (MediaDeviceLockException e) {
            new FrameworkLog(RestoreErrorIds._logInfo, 517, e).log();
        }
    }
}

